﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Drawing.Drawing2D

Public Class MainForm
    Inherits System.Windows.Forms.Form


    ''' <summary>
    ''' 此处声明必要的类变量。
    ''' </summary>
    ''' <remarks></remarks>
    Dim demoPen As New Pen(Color.Black)
    Dim penColor As Color = Color.BurlyWood


    ''' <summary>
    ''' 这用于打开和关闭处理点线交替
    ''' 的计时器。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnCycle_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCycle.Click
        timerCycle.Interval = 333
        timerCycle.Enabled = Not timerCycle.Enabled
        If timerCycle.Enabled Then
            btnCycle.Text = "Stop!"
        Else
            btnCycle.Text = "Animate"
        End If
    End Sub


    ''' <summary>
    ''' 此 Sub 根据用户在 ColorDialog 中的选择
    ''' 设置颜色。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnSetColor_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSetColor.Click
        Dim cdlg As New ColorDialog()

        If cdlg.ShowDialog() = Windows.Forms.DialogResult.OK Then
            penColor = cdlg.Color
            txtColor.Text = cdlg.Color.ToString()
            txtColor.BackColor = cdlg.Color
        End If
    End Sub


    ''' <summary>
    ''' 当加载 Form1 时，此 Sub 设置页的默认值
    ''' 并生成必要的组合框。注意此处的组合框
    ''' 包含各种对象而不是标准字符串。这样，
    ''' 可以在将它们的值分配给其他对象时 
    ''' 直接使用它们。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' 设置 StartCap 和 EndCap 选项。
        For Each cap As LineCap In System.Enum.GetValues(GetType(LineCap))
            comboStartCap.Items.Add(cap)
            comboEndCap.Items.Add(cap)
        Next

        ' 设置虚线线帽。
        For Each dash As DashCap In System.Enum.GetValues(GetType(DashCap))
            comboDashCap.Items.Add(dash)
        Next

        ' 设置线条相交
        For Each join As LineJoin In System.Enum.GetValues(GetType(LineJoin))
            comboLineJoin.Items.Add(join)
        Next

        ' 设置线条相交
        For Each style As DashStyle In System.Enum.GetValues(GetType(DashStyle))
            comboLineStyle.Items.Add(style)
        Next

        ' 设置对齐
        For Each align As PenAlignment In System.Enum.GetValues(GetType(PenAlignment))
            comboAlignment.Items.Add(align)
        Next
    End Sub

    ''' <summary>
    '''  RadioCheckBox 代码
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub radioColor_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radioColor.CheckedChanged
        txtColor.Enabled = radioColor.Checked
        btnSetColor.Enabled = radioColor.Checked
        comboBrush.Enabled = radioBrush.Checked
    End Sub

    ''' <summary>
    ''' RedrawPicture 收集所有用户定义的信息，并使用它
    ''' 创建 Pen 对象，然后使用该对象绘制三个不同的图画
    ''' 之一。注意此 Sub 几乎可处理用户界面激发的
    ''' 所有事件。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub RedrawPicture(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles MyBase.Activated, comboTransform.SelectedIndexChanged, updownMiterLimit.ValueChanged, comboLineStyle.SelectedIndexChanged, comboLineJoin.SelectedIndexChanged, comboEndCap.SelectedIndexChanged, comboStartCap.SelectedIndexChanged, updownWidth.ValueChanged, comboShape.SelectedIndexChanged, txtColor.TextChanged, comboAlignment.SelectedIndexChanged, comboDashCap.SelectedIndexChanged, comboBrush.SelectedIndexChanged

        Dim penBrush As Brush = New SolidBrush(Color.Black)
        Dim blackThinPen As New Pen(Color.Black)

        ' 重置 PictureBox
        pbLines.CreateGraphics().Clear(pbLines.BackColor)
        pbLines.Refresh()
        ' 去除 Pen 上的任何当前变换
        demoPen.ResetTransform()
        ' 设置选择了自定义类型的虚线时要使用的 DashPattern
        demoPen.DashPattern = New Single() {0.5, 0.25, 0.75, 1.5}

        ' 由于可以向 Pen 分配 Color 或 Brush，但不会同时分配两者，
        ' 因此此代码确定应该使用哪一个。注意分配一个 Color
        ' 与向钢笔分配一个 SolidBrush 完全相同。
        If radioColor.Checked Then
            demoPen.Color = penColor
        Else
            Select Case comboBrush.Text
                Case "Solid"
                    ' 与向 Pen 分配 Color 相同
                    penBrush = New SolidBrush(penColor)
                Case "Hatch"
                    ' 定义要使用的 HatchBrush，在此例中为 Plaid。
                    penBrush = New HatchBrush(HatchStyle.Plaid, penColor)
                Case "Texture"
                    ' 分配一个要用作画笔的位图图像。
                    penBrush = New TextureBrush( _
                        My.Resources.WaterLilies, WrapMode.Tile)
                Case "Gradient"
                    ' 生成一个要用作画笔的 LinearGradientBrush。也可以
                    '    在此处使用其他类型的渐变画笔。
                    penBrush = New LinearGradientBrush( _
                        New Point(0, 0), _
                        New Point(pbLines.Width, pbLines.Height), _
                        Color.AliceBlue, Color.DarkBlue)
            End Select

            demoPen.Brush = penBrush
        End If

        ' 为所有钢笔对象设置用户定义的值
        ' 钢笔的宽度以像素为单位
        demoPen.Width = updownWidth.Value
        ' DashStyle 确定线条的外观。
        ' 可以是虚线、点划线，甚至是自定义线条
        demoPen.DashStyle = CType(comboLineStyle.SelectedItem, DashStyle)
        ' MiterLimit 是确定应该何时剪辑
        ' 两个邻近线条的斜接边缘的浮点数。默认值为 10.0
        demoPen.MiterLimit = updownMiterLimit.Value
        ' StartCap 确定应该放在钢笔
        ' 绘制的线条开头的线帽
        demoPen.StartCap = CType(comboStartCap.SelectedItem, LineCap)
        ' EndCap 确定应该放在钢笔
        ' 绘制的线条末尾的线帽
        demoPen.EndCap = CType(comboEndCap.SelectedItem, LineCap)
        ' DashCap 确定应该放在钢笔
        ' 绘制的线条中的任何虚线两端的线帽
        demoPen.DashCap = CType(comboDashCap.SelectedItem, DashCap)
        ' LineJoin 确定两条邻近线条应该如何连接。
        ' 例如，它们可以是圆角连接或斜接连接。
        demoPen.LineJoin = CType(comboLineJoin.SelectedItem, LineJoin)
        ' Alignment 确定钢笔应该在指定线条
        ' 的哪一“侧”绘制。例如，Inset 将导致
        ' 钢笔在圆形的内部绘制。
        demoPen.Alignment = CType(comboAlignment.SelectedItem, PenAlignment)

        ' 变换用于钢笔的某些高级功能。例如，
        ' 可以创建 caligraphic 样式的钢笔。
        Select Case comboTransform.Text
            Case "None"
                ' ResetTransform 将钢笔重置为无变换
                demoPen.ResetTransform()
            Case "Scale"
                ' ScaleTransform 通过更改钢笔的宽度和高度
                '   更改钢笔的外观。例如，
                '   下面的变换使宽度只有正常宽度的
                '   一半，高度则翻倍。
                demoPen.ScaleTransform(0.5, 2)
            Case "Rotate"
                ' 仅当基础的画笔支持 RotateTransform 时才使用它。
                '    它将画笔旋转一定的
                '    角度。
                demoPen.RotateTransform(45)
            Case "Translate"
                ' 仅当基础的画笔支持 TranslateTransform 时才使用它。 
                '   它转换基础画笔。
                demoPen.TranslateTransform(2, 4)
        End Select



        ' 现在已经定义了钢笔，下面将创建一个图形对象，并在
        '   PictureBox 上重绘图像。还将使用相同命令
        '   绘制一条细黑线。这样将允许用户看到
        '   线条应绘制到的位置，并帮助说明各个属性
        '   的作用。
        Dim graphic As Graphics = pbLines.CreateGraphics()

        If Me.comboShape.Text = "Lines" Then
            ' 绘制 3 条简单线条。
            ' 使用用户定义的钢笔进行绘制
            graphic.DrawLine(demoPen, 35, 35, pbLines.Width - 35, 35)
            graphic.DrawLine(demoPen, 35, 80, 35, pbLines.Height - 35)
            graphic.DrawLine(demoPen, 90, 90, pbLines.Width - 35, _
                pbLines.Height - 35)

            ' 使用细黑钢笔进行绘制以查看效果
            graphic.DrawLine(blackThinPen, 35, 35, pbLines.Width - 35, 35)
            graphic.DrawLine(blackThinPen, 35, 80, 35, pbLines.Height - 35)
            graphic.DrawLine(blackThinPen, 90, 90, pbLines.Width - 35, _
                    pbLines.Height - 35)

        ElseIf Me.comboShape.Text = "Intersecting Lines" Then
            ' 绘制复合线条

            ' 使用点数组创建更复杂的形状
            ' 以定义多段线条。如果改为使用若干
            ' 独立线条，则即使它们是相连的，起点和 
            ' 终点线帽也将放在每个独立线条上。
            ' 此处只将它们放在复合线条的 
            ' 开头和末尾。
            Dim ptArray(5) As PointF
            ptArray(0) = New PointF(35, 35)
            ptArray(1) = New PointF(70, pbLines.Height - 75)
            ptArray(2) = New PointF(100, 35)
            ptArray(3) = New PointF(pbLines.Width - 40, pbLines.Height \ 2)
            ptArray(4) = New PointF(pbLines.Width \ 2, pbLines.Height \ 2)
            ptArray(5) = New PointF(pbLines.Width - 25, 25)

            ' 使用用户定义的钢笔绘制线条
            graphic.DrawLines(demoPen, ptArray)

            ' 使用细黑钢笔绘制线条
            graphic.DrawLines(blackThinPen, ptArray)

        ElseIf Me.comboShape.Text = "Circles and Curves" Then
            ' 绘制圆和曲线

            ' 使用用户定义的钢笔绘制曲线
            graphic.DrawEllipse(demoPen, 25, 25, 200, 200)
            graphic.DrawArc(demoPen, 55, 55, pbLines.Height - 55, _
                pbLines.Height - 55, 110, 150)

            ' 使用细黑钢笔绘制曲线
            graphic.DrawEllipse(blackThinPen, 25, 25, 200, 200)
            graphic.DrawArc(blackThinPen, 55, 55, pbLines.Height - 55, _
                pbLines.Height - 55, 110, 150)

        End If

    End Sub

    ''' <summary>
    ''' 当计时器激发时，DashOffset 属性值递增，线条中的
    ''' 点和短划线呈现动画效果。
    ''' </summary>
    Private Sub timerCycle_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timerCycle.Tick
        demoPen.DashOffset = (demoPen.DashOffset + 0.5F) Mod 30
        RedrawPicture(Me, New System.EventArgs())
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
